/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.util;

import com.ibm.hwmca.fw.servlet.pmod.util.NoStandardFormatterException;
import com.ibm.hwmca.fw.util.Trace;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class TimeFormatter {
    private static final String TRACE_MASKT = "XPMUTIFT";
    private static final String TRACE_MASKF = "XPMUTIFF";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$Calendar;

    private TimeFormatter() {
    }

    public static Object convert(Object subject, Class desired) throws NoStandardFormatterException {
        Trace.trace(TRACE_MASKF, "TimeFormatter.convert( " + subject + "(class=" + (subject != null ? subject.getClass().toString() : "null") + "), " + desired + " )");
        try {
            if (subject == null || desired == null) {
                return null;
            }
            if (desired == (class$java$lang$String == null ? (class$java$lang$String = TimeFormatter.class$("java.lang.String")) : class$java$lang$String)) {
                return TimeFormatter.convertToString(subject);
            }
            if (desired == (class$java$util$Date == null ? (class$java$util$Date = TimeFormatter.class$("java.util.Date")) : class$java$util$Date)) {
                return TimeFormatter.convertToDate(subject);
            }
            if (desired == (class$java$util$Calendar == null ? (class$java$util$Calendar = TimeFormatter.class$("java.util.Calendar")) : class$java$util$Calendar)) {
                return TimeFormatter.convertToCalendar(subject);
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "TimeFormatter caught exception attempting to format inbound object: " + e);
        }
        Trace.trace(TRACE_MASKT, "TimeFormatter is unable to apply standard formatter.");
        throw new NoStandardFormatterException("TimeFormatter is unable to find appropriate standard conversion.");
    }

    private static Date convertToDate(Object subject) throws NoStandardFormatterException {
        if (subject instanceof Date) {
            return (Date)subject;
        }
        if (subject instanceof String) {
            return TimeFormatter.convertStringToDate((String)subject);
        }
        if (subject instanceof Calendar) {
            return ((Calendar)subject).getTime();
        }
        Trace.trace(TRACE_MASKT, "TimeFormatter.convert() [Date.class] Unable to apply standard formatter.");
        throw new NoStandardFormatterException("TimeFormatter is unable to find appropriate standard conversion.");
    }

    private static Calendar convertToCalendar(Object subject) throws NoStandardFormatterException {
        if (subject instanceof Calendar) {
            return (Calendar)subject;
        }
        if (subject instanceof String) {
            Date date = TimeFormatter.convertStringToDate((String)subject);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar;
        }
        if (subject instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)subject);
            return calendar;
        }
        Trace.trace(TRACE_MASKT, "TimeFormatter.convert() [Calendar.class] Unable to apply standard formatter.");
        throw new NoStandardFormatterException("TimeFormatter is unable to find appropriate standard conversion.");
    }

    private static String convertToString(Object subject) throws NoStandardFormatterException {
        if (subject instanceof String) {
            return (String)subject;
        }
        if (subject instanceof Date) {
            DateFormat format = DateFormat.getTimeInstance();
            Trace.trace(TRACE_MASKF, "TimeFormatter returning date->string: " + format.format((Date)subject));
            return format.format((Date)subject);
        }
        if (subject instanceof Calendar) {
            Date time = ((Calendar)subject).getTime();
            DateFormat format = DateFormat.getTimeInstance();
            Trace.trace(TRACE_MASKF, "TimeFormatter returning calendar->string: " + format.format(time));
            return format.format(time);
        }
        Trace.trace(TRACE_MASKT, "TimeFormatter.convert() [String.class] Unable to apply standard formatter.");
        throw new NoStandardFormatterException("TimeFormatter is unable to find appropriate standard conversion.");
    }

    public static Date convertStringToDate(String subject) throws NoStandardFormatterException {
        try {
            SimpleDateFormat format = new SimpleDateFormat("h:mm:s a");
            Trace.trace(TRACE_MASKF, "TimeFormatter returning: " + format.parse(subject));
            return format.parse(subject);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception parsing (" + subject + ") as SimpleDateFormat, trying SHORT");
            try {
                DateFormat format = DateFormat.getTimeInstance(3);
                return format.parse(subject);
            }
            catch (Exception e1) {
                Trace.trace(TRACE_MASKF, "Exception parsing (" + subject + ") as SHORT, trying MEDIUM");
                try {
                    DateFormat format = DateFormat.getTimeInstance(2);
                    return format.parse(subject);
                }
                catch (Exception e2) {
                    Trace.trace(TRACE_MASKF, "Exception parsing (" + subject + ") as MEDIUM, trying LONG");
                    try {
                        DateFormat format = DateFormat.getTimeInstance(1);
                        return format.parse(subject);
                    }
                    catch (Exception e3) {
                        Trace.trace(TRACE_MASKF, "Exception parsing (" + subject + ") as LONG, trying FULL");
                        try {
                            DateFormat format = DateFormat.getTimeInstance(0);
                            return format.parse(subject);
                        }
                        catch (Exception e4) {
                            Trace.trace(TRACE_MASKF, "Exception parsing (" + subject + ") as FULL, punting");
                            throw new NoStandardFormatterException("Unable to find appropriate DateFormatter for String: " + subject);
                        }
                    }
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

